document.addEventListener('DOMContentLoaded', () => {
    const params = new URLSearchParams(window.location.search);
    const query = params.get('q');

    if (query) {
        document.getElementById('search-query-display').textContent = query;
        document.getElementById('global-search-input').value = query; // Set input value
        performSearch(query);
    } else {
        document.getElementById('search-results-container').innerHTML = `
            <div class="no-results">
                <p>Please enter a search term.</p>
            </div>
        `;
    }
});

function performSearch(query) {
    fetch(`api/search.php?q=${encodeURIComponent(query)}`)
        .then(res => res.json())
        .then(data => {
            const container = document.getElementById('search-results-container');

            if (data.status === 'success') {
                const candidates = data.data.candidates || [];
                const jobs = data.data.jobs || [];

                if (candidates.length === 0 && jobs.length === 0) {
                    container.innerHTML = `
                        <div class="no-results">
                            <i class="fa-solid fa-magnifying-glass mb-3 text-2xl"></i>
                            <p>No results found matching "${query}".</p>
                        </div>
                    `;
                    return;
                }

                let html = '';

                // Candidates Section
                if (candidates.length > 0) {
                    html += `
                        <div class="search-results-section">
                            <div class="section-header">
                                <h3>Candidates (${candidates.length})</h3>
                            </div>
                            <div class="results-list">
                    `;

                    candidates.forEach(c => {
                        html += `
                            <div class="result-card" onclick="window.location.href='candidate-detail.html?id=${c.id}'">
                                <div class="result-info">
                                    <h4>${c.name}</h4>
                                    <p>${c.role} • ${c.email}</p>
                                </div>
                                <div class="result-meta">
                                    <span class="badge badge-info">${c.status}</span>
                                </div>
                            </div>
                        `;
                    });

                    html += `</div></div>`;
                }

                // Jobs Section
                if (jobs.length > 0) {
                    html += `
                        <div class="search-results-section">
                            <div class="section-header">
                                <h3>Jobs (${jobs.length})</h3>
                            </div>
                            <div class="results-list">
                    `;

                    jobs.forEach(j => {
                        html += `
                            <div class="result-card" onclick="window.location.href='job-detail.html?id=${j.id}'">
                                <div class="result-info">
                                    <h4>${j.title}</h4>
                                    <p>${j.department} • ${j.location}</p>
                                </div>
                                <div class="result-meta">
                                    <span class="badge badge-success">${j.type}</span>
                                </div>
                            </div>
                        `;
                    });

                    html += `</div></div>`;
                }

                container.innerHTML = html;

            } else {
                container.innerHTML = '<div class="text-red-500">Error loading results.</div>';
            }
        })
        .catch(err => {
            console.error(err);
            document.getElementById('search-results-container').innerHTML = '<div class="text-red-500">Network error.</div>';
        });
}
