<?php
require_once '../includes/db_connect.php';

header('Content-Type: application/json');

try {
    // Fetch all interviews with candidate and job details
    // We filter for interviews that are Scheduled or Completed?
    // Let's just fetch all 'Scheduled' ones + any history if needed.
    // For calendar, we probably want everything.
    
    $stmt = $pdo->query("
        SELECT 
            i.id,
            c.id as candidate_id,
            i.scheduled_at,
            i.type,
            i.status,
            c.full_name as candidate_name,
            j.title as job_title
        FROM interviews i
        JOIN applications a ON i.application_id = a.id
        JOIN candidates c ON a.candidate_id = c.id
        JOIN jobs j ON a.job_id = j.id
        ORDER BY i.scheduled_at ASC
    ");
    
    $interviews = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Transform to friendly format if needed, but raw is okay.
    // JS side will parse date.
    
    echo json_encode($interviews);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
